---
title: Cloudflare cache responses · Cloudflare Cache (CDN) docs
description: The CF-Cache-Status header output indicates whether a resource is
  cached or not. To investigate cache responses returned by this header, use
  services like Redbot, webpagetest.org, or a visual tool like Cloudflare Optics
  plugin.
lastUpdated: 2025-09-26T14:07:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cache/concepts/cache-responses/
  md: https://developers.cloudflare.com/cache/concepts/cache-responses/index.md
---

The `CF-Cache-Status` header output indicates whether a resource is cached or not. To investigate cache responses returned by this header, use services like [Redbot](https://redbot.org/), [webpagetest.org](http://www.webpagetest.org/), or a visual tool like [Cloudflare Optics plugin](https://chromewebstore.google.com/detail/cloudflare-optics/mdjgbjnbdnhneejmmaabmccfehigbjbe).

`Age` response header

The `Age` response header is a header returned from cache that specifies the time in seconds that an asset has been in Cloudflare's cache. This value resets if the asset is revalidated, purged, or evicted and then re-cached.

The `Age` header is only present for responses served from the cache. It will not appear on a cache MISS, dynamic traffic, the first request that populates the lower tier HIT from tiered cache `CacheTieredFill=true` or any responses that did not originate from the cache (for example, responses generated by a Worker that bypassed the cache).

Below you can find a comprehensive breakdown of Cloudflare's cache response statuses.

## HIT

The resource was found in Cloudflare's cache.

## MISS

The resource was not found in Cloudflare's cache and was served from the origin web server.

## NONE/UNKNOWN

Cloudflare generated a response that denotes the asset is not eligible for caching. This may have happened because:

* A Worker generated a response without sending any subrequests. In this case, the response did not come from cache, so the cache status will be `none/unknown`.

* A Worker request made a subrequest (`fetch`). In this case, the subrequest will be logged with a cache status, while the main request will be logged with `none/unknown` status (the main request did not hit cache, since Workers sits in front of cache).

* A WAF custom rule was triggered to block a request. The response will come from the Cloudflare global network before it hits cache. Since there is no cache status, Cloudflare will log as `none/unknown`.

* A [redirect rule](https://developers.cloudflare.com/rules/url-forwarding/) or [Always Use HTTPS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/always-use-https/) caused the global network to respond with a redirect to another asset/URL. This redirect response happens before the request reaches cache, so the cache status is `none/unknown`.

## EXPIRED

The resource was found in Cloudflare's cache but was expired and served from the origin web server.

## STALE

The resource was served from Cloudflare's cache but was expired. Cloudflare could not contact the origin web server to retrieve an updated resource.

## BYPASS

The origin web server instructed Cloudflare to bypass cache via a `Cache-Control` header set to `no-cache`, `private`, or `max-age=0` even though Cloudflare originally preferred to cache the asset. BYPASS is returned when enabling [Origin Cache-Control](https://developers.cloudflare.com/cache/concepts/cache-control/). Cloudflare also sets BYPASS when your origin web server sends cookies in the response header. If the Request to your origin web server includes an `Authorization` header, in some cases the response will also be BYPASS. Refer to [Conditions](https://developers.cloudflare.com/cache/concepts/cache-control/#conditions) in the Origin Cache-Control behavior section for more details.

## REVALIDATED

The resource is served from Cloudflare's cache but is stale. The resource was revalidated by either an `If-Modified-Since` header or an `If-None-Match` header.

## UPDATING

The resource was served from Cloudflare's cache and was expired, but the origin web server is updating the resource. `UPDATING` is typically only seen for very popular cached resources.

## DYNAMIC

Cloudflare does not consider the asset eligible to cache and your Cloudflare settings do not explicitly instruct Cloudflare to cache the asset. Instead, the asset was requested from the origin web server. Use [Cache Rules](https://developers.cloudflare.com/cache/how-to/cache-rules/) to implement custom caching options.
